function [outputArg1,outputArg2] = PropRes_ipsiContra(inputArg1,inputArg2)
% 画ROI区域，有反应位点比例随时间变化图
%   此处提供详细说明
Cri_Chan_LR = Select_chanLR(DOTAnatomy1);
workpath='E:\Software\brainstorm_db\Protocol01\data\TotalSub\6sub\';
ChanFile=load([workpath,'channel_221021_1815.mat']);
SubNum=6;
IC={'contra','ipsi'};
Res_Screen=1920;
for i_sub=1:SubNum
    DataPath=['E:\DATA_SEEG\',FullNameT{i_sub},'_data\处理数据集\',SimplyNameT{i_sub},'_VisualAwareData\'];
    dataList=dir([DataPath,'*_VisualAware_*.mat']);
    load([DataPath,dataList(1).name]);
    LR_sti1(i_sub)=Trial(1).Sti.LocX;
end
    LR_sti=(LR_sti1>Res_Screen/2)+1;  % 1 左，2右

ChanLabel=[];
for i_chan=1:length(ChanFile.Channel)
    ChanLabel{1,i_chan}=ChanFile.Channel(i_chan).Name;
end
% for i_LR=1:length(Cri_Chan_LR)
    Cri_Chan_IpsiContra={};  % 1 ipsi 2 contra
    Cri_Chan(SubNum+1:end)=[];
   for i_sub=1:length(LR_sti)
   if LR_sti(i_sub)==1
    Cri_Chan_IpsiContra{1}(i_sub)=Cri_Chan_LR{1}(i_sub);
    Cri_Chan_IpsiContra{2}(i_sub)=Cri_Chan_LR{2}(i_sub);
   elseif LR_sti(i_sub)==2
   Cri_Chan_IpsiContra{1}(i_sub)=Cri_Chan_LR{2}(i_sub);
   Cri_Chan_IpsiContra{2}(i_sub)=Cri_Chan_LR{1}(i_sub);
   end
   end

   i_dis=1;
for i_sub=1:6
     Chan_temp=Cri_Chan(i_sub).roi;
     if isempty(Chan_temp)
         index_Disc(i_dis)=i_sub;
         i_dis=i_dis+1;
         continue
     end
end

for i_sub1=1:3
Fraction1=[];
for i_IC=1:length(Cri_Chan_LR)
Cri_Chan=Cri_Chan_IpsiContra{i_IC};


% index_Disc=[];

Cri_Chan(index_Disc)=[];  %仅保留两边都有电极的被试

i_chanT=1;
RTepoch={};
AMP={};
for i_sub=1:length(Cri_Chan)
% for i_sub=i_sub1
     Chan_temp=Cri_Chan(i_sub).roi;
    for i_chan=1:length(Chan_temp)
       NameTemp=Cri_Chan(i_sub).name1;
       NameTemp1=strcat(Chan_temp{i_chan},'_',NameTemp);
       [Lia,Locb]=ismember(NameTemp1,ChanLabel);
       RTepoch{2,i_chanT}=Result(1).RTepochT{Locb}; % HG
       RTepoch{1,i_chanT}=Result(2).RTepochT{Locb}; % 2ERP 1HG

       AMP{2}(i_chanT,:,:)=squeeze(Result(1).AmpT(Locb,:,:)); % HG
       AMP{1}(i_chanT,:,:)=squeeze(Result(2).AmpT(Locb,:,:)); % ERP
       i_chanT=i_chanT+1;
    end
end

DataType={'ERP','HG'};
 % AMP计算 3维  ChanXTimex条件(LU/NU/NA/HA)
for i_amp=1:length(AMP)
AMP1{i_IC,1}=AMP{1}(:,:,3)-AMP{1}(:,:,2); %此处计算的是NA/NU的差异，即Gain
AMP1{i_IC,2}=AMP{2}(:,:,3)-AMP{1}(:,:,2);
end


Time=0:650;


for i_data=1:size(RTepoch,1)
Data_temp=zeros(size(RTepoch,2),numel(Time));
for i_chan=1:length(RTepoch) 
temp=RTepoch{i_data,i_chan};
if isempty(temp) % 如果没有反应，跳过循环
continue
end
for i_temp=1:size(temp,2)
Data_temp(i_chan,temp(1,i_temp):temp(2,i_temp))=1;
end
end

RespN=[];
for i_time=1:size(Time,2)
RespN(i_time)=numel(find(Data_temp(:,i_time)~=0));
end
TotalN=size(Data_temp,1);
Fraction=RespN./TotalN*100;
Fraction1(i_data,:,i_IC)=smoothdata(Fraction,2,'movmean',20); % HG/ERP *Time*ipsi/contra

figure;
plot(Time,Fraction1(i_data,:,i_IC),'LineWidth',2)
ylabel('Fractions of awareness-related sites (%)')
xlabel('Time from  Cue Onset (ms)')
title(['n=',num2str(size(Data_temp,1)),' sites'])
% xline(650,'k--','LineWidth',2);
xlim([0,650])
box off
ax=gca;
ax.FontSize=15;
ax.LineWidth=2;

% SavePath='E:\DATA_SEEG\elifeReviewResults\';
% saveas(gcf,[SavePath,'Fractions of Resp Sites',DataType{i_data},'.fig']);
% saveas(gcf,[SavePath,'Fractions of Resp Sites',DataType{i_data},'.tif']);
close
end

figure;
plot(Time,Fraction1(:,:,i_IC),'LineWidth',2)
ylabel('Fractions of awareness-related sites (%)')
xlabel('Time from  Cue Onset (ms)')
title(['n=',num2str(size(Data_temp,1)),' sites'])
% xline(650,'k--','LineWidth',2);
xlim([0,650])
box off
ax=gca;
ax.FontSize=15;
ax.LineWidth=2;
% legend(DataType,'Location','none','Position',0.301726190476191,0.792198418603463,0.181547619047619,0.118650793650794);
legend boxoff

% SavePath='E:\DATA_SEEG\elifeReviewResults\';
% saveas(gcf,[SavePath,'Fractions of Resp Sites.fig']);
% saveas(gcf,[SavePath,'Fractions of Resp Sites.tif']);
close
SiteNum(i_IC)=size(Data_temp,1);
end

% AMP画图
yText={'Magnitude (μV)','Power(μV^2)'};
Time1=-200:1299;
for i_data1=1:2
    amp_temp=[];
% figure
amp_temp(2,:)=mean(abs(AMP1{1,i_data1}),1);
amp_temp(1,:)=mean(abs(AMP1{2,i_data1}),1);
amp_temp1=smoothdata(amp_temp,2,'movmean',20);

sem_temp(2,:)=std(abs(AMP1{1,i_data1}),[],1)./sqrt(size(AMP1{1,i_data1},1)-1);
sem_temp(1,:)=std(abs(AMP1{2,i_data1}),[],1)/sqrt(size(AMP1{2,i_data1},1)-1);
sem_temp1=smoothdata(sem_temp,2,'movmean',20);

LE1=amp_temp1-sem_temp1;
HE1=amp_temp1+sem_temp1;
% PLVgain_avg1(1,:)=PLVgain_avg(2,:);
% PLVgain_avg1(2,:)=PLVgain_avg(1,:);
LineColor={[0.6350 0.0780 0.1840],[0.4660 0.6740 0.1880]};
divTime=-200:1299;
figure
 hold on;
for j=1:size(amp_temp1,1)  % channelxtimexcondition
   
    LE=LE1(j,:);
    HE=HE1(j,:);
    xconf = [divTime divTime(end:-1:1) ] ;%构造正反向的x值，作为置信区间的横坐标值
    yconf = [LE HE(end:-1:1)];%构造y方向的上下范围，作为置信区间的纵坐标值
    p = fill(xconf,yconf,LineColor{1,j});%定义填充区间
    p.EdgeColor = LineColor{1,j};%定义区间边界的填充颜色，此处不设置
    p.LineStyle='none';
    alpha(0.35)
end





h=plot(Time1,amp_temp1,'LineWidth',2);
 h(1).Color=[0.6350 0.0780 0.1840];
    h(2).Color=[0.4660 0.6740 0.1880];
xlim([-200 800])
% legend(IC,'AutoUpdate','off','Location','best')
legend(h,IC,'AutoUpdate','off','Position',[0.301726190476191,0.792198418603463,0.181547619047619,0.118650793650794]);

title([DataType{i_data1},' Gain'])

xline(650,'k--','LineWidth',2);
xline(0,'k--','LineWidth',2);
box off
ax=gca;
ax.FontSize=15;
ax.LineWidth=2;
legend boxoff
ylabel(yText{i_data1})
xlabel('Time from Cue Onset (ms)')
% saveas(gcf,[DataType{i_data1},'_P',num2str(i_sub1),'_AMP_IpsiContra.fig'])
% saveas(gcf,[DataType{i_data1},'_P',num2str(i_sub1),'_AMP_IpsiContra.tif'])
saveas(gcf,[DataType{i_data1},'_AMP_IpsiContra.fig'])
saveas(gcf,[DataType{i_data1},'_AMP_IpsiContra.tif'])
end
 %DataType{i_data},'P',num2str(i_sub1),


for i_data=1:length(IC)
    temp1=squeeze(Fraction1(i_data,:,:));
    temp=[];
    temp(1,:)=temp1(:,2);
    temp(2,:)=temp1(:,1);
    figure
    h=plot(Time,temp','LineWidth',2);
    h(1).Color=[0.6350 0.0780 0.1840];
    h(2).Color=[0.4660 0.6740 0.1880];
    ylabel('Fractions of awareness-related sites (%)')
    xlabel('Time from  Cue Onset (ms)')
%     title([DataType{i_data},' (N=3 patients)'])
 title([DataType{i_data}])
    % xline(650,'k--','LineWidth',2);
    xlim([0,650])
    box off
    ax=gca;
    ax.FontSize=15;
    ax.LineWidth=2;
    legend({[IC{1},' (n=',num2str(SiteNum(2)),' sites)'], ...
        [IC{2},' (n=',num2str(SiteNum(1)),' sites)']},'Location','northwest');
    legend boxoff
%     SavePath='E:\DATA_SEEG\elifeReviewResults\';
% saveas(gcf,[SavePath,'Fractions of Resp Sites_IpsiContra_',DataType{i_data},'P',num2str(i_sub1),'.fig']);
% saveas(gcf,[SavePath,'Fractions of Resp Sites_IpsiContra_',DataType{i_data},'P',num2str(i_sub1),'.tif']);
close
end
end




%% PLV
conditions={'NA','NU','HA','LU'};
plv_condi={};
% SubIndex=[1 5 6]; %两侧都有电极的被试编号
% for i_IC=1:length(Cri_Chan_LR)  % Ipsi-Contra条件
% Cri_Chan=Cri_Chan_IpsiContra{i_IC};
% Cri_Chan(index_Disc)=[];  %仅保留两边都有电极的被试
% SimplyNameT={'lr','cyk','sjh'};
% for i_sub=1:length(Cri_Chan)
%         SimplyName=SimplyNameT{i_sub};
%         workpath=['E:\Software\brainstorm_db\Protocol01\data\',SimplyName,'\',...
%             'NA','_bipolar_2\'];
%         temp=dir([workpath,'timefreq_connectn_plvt_*']);
%         fileName=temp.name;
% plvMatrix_lr=load([workpath,fileName]);
% [~,ChanAdr]=ismember(Cri_Chan(i_sub).roi,plvMatrix_lr.RowNames); %注意ismember的参数顺序
% Cri_Chan_IpsiContra{i_IC}(SubIndex(i_sub)).adr_roi=ChanAdr;
% 
% end
% end


% ICindex=[2 1];
for i_IC=1:length(Cri_Chan_LR)  % Ipsi-Contra条件
Cri_Chan=Cri_Chan_IpsiContra{i_IC};
Cri_Chan(index_Disc)=[];  %仅保留两边都有电极的被试
SimplyNameT={'lr','cyk','sjh'};
% SimplyNameT={'sjh'};
for i_condi=1:length(conditions)
    plv_subs=[];
    
    for i_sub=1:length(SimplyNameT)
        

        SimplyName=SimplyNameT{i_sub};
        workpath=['E:\Software\brainstorm_db\Protocol01\data\',SimplyName,'\',...
            conditions{i_condi},'_bipolar_2\'];
        temp=dir([workpath,'timefreq_connectn_plvt_*']);
        fileName=temp.name;
        plvMatrix_lr=load([workpath,fileName]);
        data_plv1 = bst_memory('GetConnectMatrix',plvMatrix_lr);
      [~,ChanAdr]=ismember(Cri_Chan(i_sub).roi,plvMatrix_lr.RowNames); %注意ismember的参数顺序
%     [~,ChanAdr]=ismember(Cri_Chan(3).roi,plvMatrix_lr.RowNames); %注意ismember的参数顺序
   
%       temp_ChanAdr=find(ChanAdr);
        if ~isempty(ChanAdr)
%              
%             IC_disc=Cri_Chan_IpsiContra{1,ICindex(i_IC)}(SubIndex(i_sub)).adr_roi ;
%             disc_adr1=ones(1,length(plvMatrix_lr.RowNames));
%             disc_adr1(IC_disc)=0; 
%             disc_adr=find(disc_adr1);% 将另外半球的
% 
%             plv_temp1=data_plv1(ChanAdr,disc_adr,:,1);  % chan X chan X time X freqband, theta
%              plv_temp1=data_plv1(temp_ChanAdr,:,:,1);  % chan X chan X time X freqband, theta
           plv_temp1=data_plv1(ChanAdr,:,:,1);  % chan X chan X time X freqband, theta
           
             plv_temp2=squeeze(mean(plv_temp1,2));
            if size(plv_temp2,2)==1
            plv_temp2=plv_temp2';
            end
            plv_subs=[plv_subs;plv_temp2];
            plv_temp3=mean(plv_temp2,1);
%             figure
%             plot(plvMatrix_lr.Time,plv_temp2);
%             xlim([-0.2,1.2]);
%             legend on
%             title(SimplyName)
        end
    end
  plv_condi{i_IC,i_condi}=plv_subs;
%   plv_condi{2,i_condi}=conditions{i_condi};
% plv_condi{2,i_condi}=conditions{i_condi};
end

end

% 画图
Index=[2 1];
for i_ic=1:2
PLVgain_avg(i_ic,:)=mean(plv_condi{Index(i_ic),1}-plv_condi{Index(i_ic),2},1);
PLVgain_sem(i_ic,:)=std(plv_condi{Index(i_ic),1}-plv_condi{Index(i_ic),2},[],1)./sqrt(size(plv_condi{Index(i_ic),1},1)-1);
end
LE1=PLVgain_avg-PLVgain_sem;
HE1=PLVgain_avg+PLVgain_sem;
% PLVgain_avg1(1,:)=PLVgain_avg(2,:);
% PLVgain_avg1(2,:)=PLVgain_avg(1,:);
LineColor={[0.6350 0.0780 0.1840],[0.4660 0.6740 0.1880]};
divTime=-490:1299;
figure
 hold on;
for j=1:size(PLVgain_avg,1)  % channelxtimexcondition
   
    LE=LE1(j,:);
    HE=HE1(j,:);
    xconf = [divTime divTime(end:-1:1) ] ;%构造正反向的x值，作为置信区间的横坐标值
    yconf = [LE HE(end:-1:1)];%构造y方向的上下范围，作为置信区间的纵坐标值
    p = fill(xconf,yconf,LineColor{1,j});%定义填充区间
    p.EdgeColor = LineColor{1,j};%定义区间边界的填充颜色，此处不设置
    p.LineStyle='none';
    alpha(0.35)
end



h=plot(-490:1299,PLVgain_avg,'LineWidth',2);
xlim([-200 800])
 h(1).Color=[0.6350 0.0780 0.1840];
    h(2).Color=[0.4660 0.6740 0.1880];
    legend(h,IC,'AutoUpdate','off','Position',[0.301726190476191,0.792198418603463,0.181547619047619,0.118650793650794]);
    
    ylabel('PLV Gain (a.u.)')
    xlabel('Time from  Cue Onset (ms)')
%     title([DataType{i_data},' (N=3 patients)'])
%  title([DataType{i_data}])
    % xline(650,'k--','LineWidth',2);
%     xlim([0,650])
    box off
    ax=gca;
    ax.FontSize=15;
    ax.LineWidth=2;
   legend boxoff
xline(0,'k--','LineWidth',2);
xline(650,'k--','LineWidth',2);
saveas(gcf,'PLVGain_IpsiContra.fig')
saveas(gcf,'PLVGain_IpsiContra.tif')
end
